% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HSIarimean.R
\name{HSIarimean}
\alias{HSIarimean}
\title{Computes Habitat Suitability Index with Arithmetic Mean}
\usage{
HSIarimean(x)
}
\arguments{
\item{x}{a vector of suitability indices.}
}
\value{
A value of habitat quality from 0 to 1 ignoring NA values.
}
\description{
\code{HSIarimean} uses arithmetic mean to combine suitability indices into an
  overarching habitat suitability index.
}
\examples{
#Determine patch quality based on a vector of four suitability indices.
HSIarimean(c(0.25, 0.25, 0.25, 0.25))

#Determine patch quality based on a vector of suitability indices with an NA.
HSIarimean(c(0.25, 0.25, NA, 0.25))

#Demonstrate error message associated with out of range outcomes.
HSIarimean(c(0.25, 0.25, 10.00, 0.25))

}
\references{
US Fish and Wildlife Service. (1980). Habitat as a basis for environmental assessment.
Ecological Services Manual, 101.

US Fish and Wildlife Service. (1980). Habitat Evaluation Procedures (HEP).
Ecological Services Manual, 102.

US Fish and Wildlife Service. (1981). Standards for the Development of
Habitat Suitability Index Models. Ecological Services Manual, 103.
}
