% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BBfinder.R
\name{BBfinder}
\alias{BBfinder}
\title{Identifies "best buy" actions}
\usage{
BBfinder(benefit, cost, CE)
}
\arguments{
\item{benefit}{a vector of restoration benefits. Typically, these are time-averaged
ecological outcomes (e.g., average annual habitat units). Often project benefits
are best presented as the "lift" associated with a restoration action
(i.e., the benefits of an alternative minus the benefits of a "no action" plan).}

\item{cost}{a vector of restoration costs. Typically, these are monetary costs
associated with a given restoration action such as project first cost or
annualized economic cost. Notably, these functions are agnostic to units, so costs
could also be non-monetary such as lost political capital or social costs
of each alternative.}

\item{CE}{numeric vector of 0's and 1's indicating whether a plan is cost-effective (1)
or non-cost-effective (0). Can be derived from ecorest::CEfinder.}
}
\value{
A list with summaries of all restoration actions as well as best buy plans only.
}
\description{
\code{BBfinder} this analysis examines the slope of the cost-effectiveness frontier to
  isolate how unit cost (cost/benefit) increases with increasing environmental benefit.
  Restoration actions with the lowest slope of unit cost are considered "best buys".
}
\examples{
#Identify cost-effective actions based on random vectors of benefits and costs
benefit <- runif(50,min=0,max=10)
cost <- runif(50, min=0,max=1000)
CE <- CEfinder(benefit, cost)
BBfinder(benefit, cost, CE)

#Identify cost-effective actions based on a small number of user-specified benefits and costs
restben <- c(0, 10, 5, 20, 20)
restcost <- c(0, 100, 100, 200, 150)
restCE <- CEfinder(restben, restcost)
BBfinder(restben, restcost, restCE)


}
\references{
Robinson R., Hansen W., and Orth K. 1995. Evaluation of environmental investments
procedures manual interim: Cost effectiveness and incremental cost analyses.
IWR Report 95-R-1. Institute for Water Resources, U.S. Army Corps of Engineers,
Alexandria, Virginia
}
