% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div.r
\name{shannon}
\alias{shannon}
\title{Shannon}
\usage{
shannon(counts, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A numeric vector.
}
\description{
Shannon alpha diversity metric.\cr\cr
The index considers both the number of different OTUs (richness) and how
evenly the observations are distributed among those OTUs (evenness).
}
\section{Calculation}{


Pre-transformation: drop all OTUs with zero abundance.

In the formulas below, \eqn{x} is a single column (sample) from \code{counts}.
\eqn{p_i} is the proportion of the \eqn{i}-th OTU in the total community.

\deqn{p_{i} = \displaystyle \frac{x_i}{\sum x}}
\deqn{D = \displaystyle -\sum_{i = 1}^{n} p_{i}\times\ln(p_{i})}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  x <- c(4, 0, 3, 2, 6)[-2]  
  p <- x / sum(x)
  -sum(p * log(p))
  #>  1.309526
}\if{html}{\out{</div>}}
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Shannon diversity values
    shannon(ex_counts)
    
    # Low diversity
    shannon(c(100, 1, 1, 1, 1)) # 0.22
    
    # High diversity
    shannon(c(20, 20, 20, 20, 20)) # 1.61
    
    # Low richness
    shannon(1:3) # 1.01
    
    # High richness
    shannon(1:100) # 4.42
    
}
\references{
Shannon CE, Weaver W 1949.
The Mathematical Theory of Communication.
University of Illinois Press.
}
\seealso{
Other alpha_diversity: 
\code{\link{chao1}()},
\code{\link{faith}()},
\code{\link{inv_simpson}()},
\code{\link{simpson}()}
}
\concept{alpha_diversity}
