% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{ec.util}
\alias{ec.util}
\title{Utility functions}
\usage{
ec.util(cmd = "sf.series", ..., js = NULL, event = "click")
}
\arguments{
\item{cmd}{Utility command name, see Details.}

\item{...}{Optional parameters for each command.}

\item{js}{Optional JavaScript function, default is NULL.}

\item{event}{Optional event name for cmd='morph', default is 'click'.}
}
\description{
tabset, table layout, support for GIS shapefiles through library 'sf'
}
\details{
\strong{cmd = 'sf.series'}\cr
\verb{     } Build \emph{leaflet} or \href{https://echarts.apache.org/en/option.html#geo.map}{geo} map series from shapefiles.\cr
\verb{     } Supported types: POINT, MULTIPOINT, LINESTRING, MULTILINESTRING, POLYGON, MULTIPOLYGON \cr
\verb{     } Coordinate system is \emph{leaflet}(default), \emph{geo} or \emph{cartesian3D} (for POINT(xyz))\cr
\verb{     } Limitations:\cr
\verb{     }\verb{     } polygons can have only their name in tooltip,  \cr
\verb{     }\verb{     } assumes Geodetic CRS is WGS 84, for conversion use \link[sf]{st_transform} with \emph{crs=4326}.\cr
\verb{     } Parameters:\cr
\verb{     }\verb{     } df - value from \link[sf]{st_read}\cr
\verb{     }\verb{     } nid - optional column name for name-id used in tooltips\cr
\verb{     }\verb{     } cs - optional \emph{coordinateSystem} value, default 'leaflet'\cr
\verb{     }\verb{     } verbose - optional, print shapefile item names in console\cr
\verb{     } Returns a list of chart series\cr
\strong{cmd = 'sf.bbox'}\cr
\verb{     } Returns JavaScript code to position a map inside a bounding box from \link[sf]{st_bbox}, for leaflet only.\cr\cr
\strong{cmd = 'sf.unzip'}\cr
\verb{     } Unzips a remote file and returns local file name of the unzipped .shp file\cr
\verb{     }\verb{     } url - URL of remote zipped shapefile\cr
\verb{     }\verb{     } shp - optional name of .shp file inside ZIP file if multiple exist. Do not add file extension. \cr
\verb{     } Returns full name of unzipped .shp file, or error string starting with 'ERROR'\cr\cr
\strong{cmd = 'geojson'} \cr
\verb{     } Custom series list from geoJson objects\cr
\verb{     }\verb{     } geojson - object from \link[jsonlite]{fromJSON}\cr
\verb{     }\verb{     } cs - optional \emph{coordinateSystem} value, default 'leaflet'\cr
\verb{     }\verb{     } ppfill - optional fill color like '#F00', OR NULL for no-fill, for all Points and Polygons\cr
\verb{     }\verb{     } nid - optional feature property for item name used in tooltips\cr
\verb{     }\verb{     } ... - optional custom series attributes like \emph{itemStyle}\cr
\verb{     } Can display also geoJson \emph{feature properties}: color; lwidth, ldash (lines); ppfill, radius (points)\cr\cr
\strong{cmd = 'layout'} \cr
\verb{     } Multiple charts in table-like rows/columns format\cr
\verb{     }\verb{     } ... - List of charts\cr
\verb{     }\verb{     } title - optional title for the entire set\cr
\verb{     }\verb{     } rows - optional number of rows\cr
\verb{     }\verb{     } cols - optional number of columns\cr
\verb{     } Returns a container \link[htmltools]{div} in rmarkdown, otherwise \link[htmltools]{browsable}.\cr
\verb{     } For 3-4 charts one would use multiple series within a \href{https://echarts.apache.org/en/option.html#grid}{grid}. \cr
\verb{     } For greater number of charts \emph{ec.util(cmd='layout')} comes in handy\cr\cr
\strong{cmd = 'tabset'} \cr
\verb{     }\verb{     } ... - a list of name/chart pairs like \emph{n1=chart1, n2=chart2}, each tab may contain a chart, see example\cr
\verb{     }\verb{     } tabStyle - tab style string, see default \emph{strTabStyle} variable in the code\cr
\verb{     }\verb{     } width - optional width size for the tabset, in CSS format, default is 100\%\cr
\verb{     } Returns A) \link[htmltools]{browsable} when '...' params are provided\cr
\verb{     } Returns B) \link[htmltools]{tagList} of tabs when in a pipe (no '...' params)\cr
\verb{     } Please note that a maximum of five(5) tabs are supported by current \emph{tabStyle}.\cr\cr
\strong{cmd = 'button'} \cr
\verb{     } UI button to execute a JS function,\cr
\verb{     }\verb{     } text - the button label\cr
\verb{     }\verb{     } js - the JS function string\cr
\verb{     }\verb{     } ... - optional parameters for the \href{https://echarts.apache.org/en/option.html#graphic.elements-rect.type}{rect} element\cr
\verb{     } Returns a graphic.elements-\href{https://echarts.apache.org/en/option.html#graphic.elements-rect.type}{rect} element.\cr\cr
\strong{cmd = 'morph'} \cr
\verb{     }\verb{     } ... - a list of charts or chart option lists\cr
\verb{     }\verb{     } event - name of event for switching charts. Default is \emph{click}.\cr
\verb{     } Returns a chart with ability to morph into other charts\cr\cr
\strong{cmd = 'fullscreen'} \cr
\verb{     } A toolbox feature to toggle fullscreen on/off. Works in a browser, not in RStudio.\cr\cr
\strong{cmd = 'rescale'} \cr
\verb{     }\verb{     } v - input vector of numeric values to rescale\cr
\verb{     }\verb{     } t - target range c(min,max), numeric vector of two\cr\cr
\strong{cmd = 'level'} \cr
\verb{     } Calculate vertical levels for timeline \emph{line} charts, returns a numeric vector\cr
\verb{     }\verb{     } df - data.frame with \emph{from} and \emph{to} columns\cr
\verb{     }\verb{     } from - name of 'from' column\cr
\verb{     }\verb{     } to - name of 'to' column\cr
}
\examples{
library(dplyr)
if (interactive()) {  # comm.out: Cran Fedora errors about some 'browser'
  library(sf)
  fname <- system.file("shape/nc.shp", package="sf")
  nc <- as.data.frame(st_read(fname))
  ec.init(load= c('leaflet', 'custom'),  # load custom for polygons
     js= ec.util(cmd= 'sf.bbox', bbox= st_bbox(nc$geometry)),
     series= ec.util(cmd= 'sf.series', df= nc, nid= 'NAME', itemStyle= list(opacity=0.3)),
     tooltip= list(formatter= '{a}')
  )
}

if (interactive()) {
 p1 <- cars |> ec.init(grid= list(top=26), height=333)  # move chart up
 p2 <- mtcars |> arrange(mpg) |> ec.init(height=333, ctype='line')
 ec.util(cmd= 'tabset', cars= p1, mtcars= p2)

 lapply(list('dark','macarons','gray','dark-mushroom'),
   function(x) cars |> ec.init(grid= list(bottom=5, top=10)) |> ec.theme(x) ) |>
 ec.util(cmd='layout', cols= 2, title= 'Layout')
}

cars |> ec.init(
  graphic = list(
    ec.util(cmd='button', text='see type', right='center', top=20,
      js="function(a) {op=ec_option(echwid); alert(op.series[0].type);}")
  )
)

colors <- c("blue","red","green")
cyls <- as.character(sort(unique(mtcars$cyl)))
sers <- lapply(mtcars |> group_by(cyl) |> group_split(), \(x) {
  cyl <- as.character(unique(x$cyl))
  list(type='scatter', id=cyl, dataGroupId=cyl, 
       data= ec.data(x |> select(mpg,hp)),
       universalTransition= TRUE)
})
oscatter <- list(
  title= list(text='Morph', left='center', subtext='click points to morph'), 
  color= colors, tooltip= list(show=TRUE),
  xAxis= list(scale=TRUE, name='mpg'), yAxis= list(scale=TRUE, name='hp'),
  series= sers
)
opie <- list(
  title= list(text= 'Average hp'), 
  color= colors, tooltip= list(show=TRUE),
  series= list(list(
    type= 'pie', label= list(show=TRUE), colorBy= 'data',
    data= ec.data(mtcars |> group_by(cyl) |> summarize(value= mean(hp)) |>
       mutate(groupId= as.character(cyl), name= as.character(cyl)),'names'),
    universalTransition= list(enabled=TRUE, seriesKey= cyls)
  ))
)
ec.util(cmd='morph', oscatter, opie) 
  
}
