% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edl_netrc.R
\name{edl_netrc}
\alias{edl_netrc}
\title{Set up Earthdata Login (EDL) credentials using a .netrc file}
\usage{
edl_netrc(
  username = default("user"),
  password = default("password"),
  netrc_path = edl_netrc_path(),
  cookie_path = edl_cookie_path(),
  cloud_config = TRUE
)
}
\arguments{
\item{username}{EarthData Login User}

\item{password}{EarthData Login Password}

\item{netrc_path}{Path to the .netrc file to be created. Defaults to the
appropriate R package configuration location given by \code{\link[tools:userdir]{tools::R_user_dir()}}.}

\item{cookie_path}{Path to the file where cookies will be stored.  Defaults
to the appropriate R package configuration location given by
\code{\link[tools:userdir]{tools::R_user_dir()}}.}

\item{cloud_config}{set \code{\link[=gdal_cloud_config]{gdal_cloud_config()}} env vars as well? logical,
default \code{TRUE}.}
}
\value{
TRUE invisibly if successful
}
\description{
This function creates a .netrc file with Earthdata Login (EDL) credentials
(username and password) and sets the necessary environment variables for GDAL
to use the .netrc file.
}
\details{
The function sets the environment variables \code{GDAL_HTTP_NETRC}
and \code{GDAL_HTTP_NETRC_FILE} to enable GDAL to use the .netrc file for
EDL authentication. GDAL_HTTP_COOKIEFILE and GDAL_HTTP_COOKIEJAR are also
set to allow the authentication to store and read access cookies.

Additionally, it manages the creation of a symbolic
link to the .netrc file if GDAL version is less than 3.7.0 (and thus
does not support GDAL_HTTP_NETRC_FILE location).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

edl_netrc()
url <- lpdacc_example_url()
terra::rast(url, vsi=TRUE)
\dontshow{\}) # examplesIf}
}
