% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_completeness.R
\name{plot_completeness}
\alias{plot_completeness}
\title{Plot Completeness of a Dataset}
\usage{
plot_completeness(data, id_var, plot = c("variables", "rows"))
}
\arguments{
\item{data}{Data frame in tidy format (see \url{https://tidyr.tidyverse.org/}).}

\item{id_var}{Row identifier variable name.}

\item{plot}{Character vector containing one or both of \code{variables} and
\code{rows}.}
}
\value{
Completeness bar plot.
}
\description{
Generates a bar plot of percentage completeness for one or both data frame
dimensions (rows/columns).
}
\examples{
data(example_data)
plot_completeness(example_data, patient_id, "variables")
}
\seealso{
Other measures of completeness: 
\code{\link{assess_completeness}()},
\code{\link{compare_completeness}()},
\code{\link{completeness_heatmap}()},
\code{\link{row_completeness}()},
\code{\link{variable_completeness}()}
}
\concept{measures of completeness}
