% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_review.R
\name{count_compare}
\alias{count_compare}
\title{Compare unique values before and after data modification}
\usage{
count_compare(
  cols2compare,
  before_tbl = NULL,
  after_tbl = NULL,
  only_diff = FALSE,
  kableout = TRUE,
  caption = NULL,
  latex_wrap = FALSE
)
}
\arguments{
\item{cols2compare}{Variables to compare between tables.}

\item{before_tbl}{Data frame from before modification was made.}

\item{after_tbl}{Data frame from after modification was made.}

\item{only_diff}{Keep only rows which differ between the tables (good for
variables with many unique values, such as numeric variables).}

\item{kableout}{Should output be a \code{kable} from \code{knitr}? If not,
returns a \code{tibble}. (Default: TRUE)}

\item{caption}{Caption for \code{kable}'s \code{caption} parameter.}

\item{latex_wrap}{Should tables be aligned vertically rather than
horizontally? Useful for wide table which would otherwise run off a page
in LaTeX format.}
}
\value{
Returns list of two tibbles or a kable (see \code{kableout}
  argument), each tallying unique values in specified columns in each input
  table.
}
\description{
Performs comparison of variables before and after a change has been applied
in order to allow manual inspection and review of modifications made during
the dataset preparation process.
}
\details{
The purpose of this function is to summarise individual alterations in a
dataset and works best with categorical variables. The output contains two
tables derived from the parameters \code{before_tbl} and \code{after_tbl}.
Each table shows the unique combinations of values in variables specified in
the parameter \code{cols2compare} if the variable is present. The tables are
presented as two sub-tables and therefore share a single table caption. This
caption is automatically generated describing the content of the two
sub-tables when the parameter \code{caption} is not specified. The
default output is a \code{kable} containing two sub-kables however if the
parameter \code{kableout} is \code{FALSE}, a list containing the two
\code{tibble}s are returned. This may preferable for further analysis on the
tables' contents.
}
\examples{
# merge data as the example modification
example_data_merged <- merge_cols(example_data, diabetes_type, diabetes, 
"diabetes_merged", rm_in_vars = TRUE)

# review the differences between the input and output of the variable merging step above:
count_compare(before_tbl = example_data,
              after_tbl = example_data_merged,
                            cols2compare = c("diabetes", "diabetes_type", "diabetes_merged"),
                            kableout = FALSE)
}
