% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputInvarCompTab.R
\name{outputInvarCompTab}
\alias{outputInvarCompTab}
\title{Compare Model Fit of Nested Dyadic Invariance Models}
\usage{
outputInvarCompTab(mods, gtTab = FALSE, writeTo = NULL, fileName = NULL)
}
\arguments{
\item{mods}{A list of nested \code{lavaan} dyadic invariance models, in the order of residual, intercept, loading, configural}

\item{gtTab}{A logical input indicating whether to generate the output in \code{gt::gt()} table object format (\code{TRUE}).
By default (\code{FALSE}), the output is generated in \code{tibble::tibble()} format.
Users can also apply the \code{writeTo} argument if they wish to export the \code{gt:gt()} table object.}

\item{writeTo}{A character string specifying a directory path to where the \code{gt::gt()} table object should be saved.
If set to ".", the file will be written to the current working directory.
The default is \code{NULL}, and examples use a temporary directory created by \code{tempdir()}.
\code{writeTo} is only relevant if \code{gtTab = TRUE}.}

\item{fileName}{A character string specifying a desired base name for the output \code{gt::gt()} file.
If a \code{fileName} is not provided (i.e., \code{fileName = NULL}), then a default will be used (i.e., "dySEM_table").
The resulting base name will automatically be appended with a \code{.rtf} file extension.
\code{fileName} is only relevant if \code{gtTab = TRUE} and \code{writeTo} is specified.}
}
\value{
A \code{tibble::tibble()} if \code{gtTab = FALSE} (default), or \code{gt::gt()} object if \code{gtTab = TRUE}, of model fit statistics for each model, as well as the difference in fit statistics between each model and the previous model
}
\description{
\code{outputInvarCompTab()} is used to compare the model fit of nested dyadic invariance models
in order from most parsimonious (residual) to least parsimonious (configural)
}
\details{
\itemize{
\item If \code{gtTab = TRUE} and \code{writeTo} is specified, then output will simultaneously be saved as a \code{.rtf} file to the user's specified directory.
\item If output file is successfully saved, a confirmation message will be printed to the console.
\item If a file with the same name already exists in the user's chosen directory, it will be overwritten.
}
}
\examples{

dvn <- scrapeVarCross(dat = commitmentQ, x_order = "spi",
x_stem = "sat.g", x_delim1 = ".", x_delim2="_", distinguish_1="1", distinguish_2="2")

sat.residual.script <- scriptCFA(dvn, lvname = "Sat",
constr_dy_meas = c("loadings", "intercepts", "residuals"), constr_dy_struct = "none")

sat.intercept.script <- scriptCFA(dvn, lvname = "Sat",
constr_dy_meas = c("loadings", "intercepts"), constr_dy_struct = "none")

sat.loading.script <- scriptCFA(dvn, lvname = "Sat",
constr_dy_meas = c("loadings"), constr_dy_struct = "none")

sat.config.script <- scriptCFA(dvn, lvname = "Sat",
constr_dy_meas = "none", constr_dy_struct = "none")

sat.residual.fit <- lavaan::cfa(sat.residual.script, data = commitmentQ,
std.lv = FALSE, auto.fix.first= FALSE, meanstructure = TRUE)

sat.intercept.fit <- lavaan::cfa(sat.intercept.script, data = commitmentQ,
std.lv = FALSE, auto.fix.first= FALSE, meanstructure = TRUE)

sat.loading.fit <- lavaan::cfa(sat.loading.script, data = commitmentQ,
std.lv = FALSE, auto.fix.first= FALSE, meanstructure = TRUE)

sat.config.fit <- lavaan::cfa(sat.config.script, data = commitmentQ,
std.lv = FALSE, auto.fix.first= FALSE, meanstructure = TRUE)

mods <- list(sat.residual.fit, sat.intercept.fit, sat.loading.fit, sat.config.fit)

outputInvarCompTab(mods,
gtTab = TRUE, writeTo = tempdir(), fileName = "dCFA_Invar")

}
