% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_dataset.R
\name{open_dataset}
\alias{open_dataset}
\title{Open a dataset from a variety of sources}
\usage{
open_dataset(
  sources,
  schema = NULL,
  hive_style = TRUE,
  unify_schemas = FALSE,
  format = c("parquet", "csv", "tsv", "sf"),
  conn = cached_connection(),
  tblname = tmp_tbl_name(),
  mode = "VIEW",
  filename = FALSE,
  recursive = TRUE,
  parser_options = list(),
  ...
)
}
\arguments{
\item{sources}{A character vector of paths to the dataset files.}

\item{schema}{The schema for the dataset. If NULL, the schema will be
inferred from the dataset files.}

\item{hive_style}{A logical value indicating whether to the dataset uses
Hive-style partitioning.}

\item{unify_schemas}{A logical value indicating whether to unify the schemas
of the dataset files (union_by_name). If TRUE, will execute a UNION by
column name across all files (NOTE: this can add considerably to
the initial execution time)}

\item{format}{The format of the dataset files. One of \code{"parquet"}, \code{"csv"},
or \code{"sf"} (spatial vector files supported by the sf package / GDAL).
if no argument is provided, the function will try to guess the type based
on minimal heuristics.}

\item{conn}{A connection to a database.}

\item{tblname}{The name of the table to create in the database.}

\item{mode}{The mode to create the table in. One of \code{"VIEW"} or \code{"TABLE"}.
Creating a \code{VIEW}, the default, will execute more quickly because it
does not create a local copy of the dataset.  \code{TABLE} will create a local
copy in duckdb's native format, downloading the full dataset if necessary.
When using \code{TABLE} mode with large data, please be sure to use a \code{conn}
connections with disk-based storage, e.g. by calling \code{\link[=cached_connection]{cached_connection()}},
e.g. \code{cached_connection("storage_path")}, otherwise the full data must fit
into RAM.  Using \code{TABLE} assumes familiarity with R's DBI-based interface.}

\item{filename}{A logical value indicating whether to include the filename in
the table name.}

\item{recursive}{should we assume recursive path? default TRUE. Set to FALSE
if trying to open a single, un-partitioned file.}

\item{parser_options}{additional options passed to the parser, e.g. to
read_csv(), see \url{https://duckdb.org/docs/stable/data/csv/overview.html#parameters}}

\item{...}{optional additional arguments passed to \code{\link[=duckdb_s3_config]{duckdb_s3_config()}}.
Note these apply after those set by the URI notation and thus may be used
to override or provide settings not supported in that format.}
}
\value{
A lazy \code{dplyr::tbl} object representing the opened dataset backed
by a duckdb SQL connection.  Most \code{dplyr} (and some \code{tidyr}) verbs can be
used directly on this object, as they can be translated into SQL commands
automatically via \code{dbplyr}.  Generic R commands require using
\code{\link[dplyr:compute]{dplyr::collect()}} on the table, which forces evaluation and reading the
resulting data into memory.
}
\description{
This function opens a dataset from a variety of sources, including Parquet,
CSV, etc, using either local file system paths, URLs, or S3 bucket URI
notation.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# A remote, hive-partitioned Parquet dataset
base <- paste0("https://github.com/duckdb/duckdb/raw/main/",
             "data/parquet-testing/hive-partitioning/union_by_name/")
f1 <- paste0(base, "x=1/f1.parquet")
f2 <- paste0(base, "x=1/f2.parquet")
f3 <- paste0(base, "x=2/f2.parquet")

open_dataset(c(f1,f2,f3), unify_schemas = TRUE)

# Access an S3 database specifying an independently-hosted (MINIO) endpoint
efi <- open_dataset("s3://neon4cast-scores/parquet/aquatics",
                    s3_access_key_id="",
                    s3_endpoint="data.ecoforecast.org")

# Use parser-options for non-standard csv:
 cars <- tempfile() # dummy data
 write.table(mtcars, cars, row.names = FALSE)

# Note nested quotes on parser option for delimiter:
 df <- open_dataset(cars, format = "csv",
                    parser_options = c(delim = "' '", header = TRUE))
\dontshow{\}) # examplesIf}
}
