% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsem.R
\name{dsem}
\alias{dsem}
\title{Fit dynamic structural equation model}
\usage{
dsem(
  sem,
  tsdata,
  family = rep("fixed", ncol(tsdata)),
  estimate_delta0 = FALSE,
  prior_negloglike = NULL,
  control = dsem_control(),
  covs = colnames(tsdata)
)
}
\arguments{
\item{sem}{Specification for time-series structural equation model structure
including lagged or simultaneous effects.  See Details section in
\code{\link[dsem]{make_dsem_ram}} for more description}

\item{tsdata}{time-series data, as outputted using \code{\link[stats]{ts}}, with \code{NA}
for missing values.}

\item{family}{Character-vector listing the distribution used for each column of \code{tsdata}, where
each element must be \code{fixed} (for no measurement error), 
\code{normal} for normal measurement error using an identity link,
\code{gamma} for a gamma measurement error using a fixed CV and log-link, 
\code{bernoulli} for a Bernoulli measurement error using a logit-link, or
\code{poisson} for a Poisson measurement error using a log-link.
\code{family="fixed"} is default behavior and assumes that a given variable is measured exactly.
Other options correspond to different specifications of measurement error.}

\item{estimate_delta0}{Boolean indicating whether to estimate deviations from equilibrium in initial year
as fixed effects, or alternatively to assume that dynamics start at some stochastic draw away from
the stationary distribution}

\item{prior_negloglike}{A user-provided function that takes as input the vector of fixed effects out$obj$par
returns the negative log-prior probability. For example
\code{prior_negloglike = function(obj) -1 * dnorm( obj$par[1], mean=0, sd=0.1, log=TRUE)}
specifies a normal prior probability
for the for the first fixed effect with mean of zero and logsd of 0.1.
NOTE:  this implementation does not work well with \code{tmbstan} and
is highly experimental.  If using priors, considering using \code{\link{dsemRTMB}}
instead.  The option in \code{dsem} is mainly intended to validate its
use in \code{dsemRTMB}.  Note that the user must load RTMB using
\code{library(RTMB)} prior to running the model.}

\item{control}{Output from \code{\link{dsem_control}}, used to define user
settings, and see documentation for that function for details.}

\item{covs}{optional: a character vector of one or more elements, with each element giving a string of variable 
names, separated by commas. Variances and covariances among all variables in each such string are 
added to the model. Warning: covs="x1, x2" and covs=c("x1", "x2") are not equivalent: 
covs="x1, x2" specifies the variance of x1, the variance of x2, and their covariance, 
while covs=c("x1", "x2") specifies the variance of x1 and the variance of x2 but not their covariance.
These same covariances can be added manually via argument `sem`, but using argument `covs` might
save time for models with many variables.}
}
\value{
An object (list) of class `dsem`. Elements include:
\describe{
\item{obj}{TMB object from \code{\link[TMB]{MakeADFun}}}
\item{ram}{RAM parsed by \code{make_dsem_ram}}
\item{model}{SEM structure parsed by \code{make_dsem_ram} as intermediate description of model linkages}
\item{tmb_inputs}{The list of inputs passed to \code{\link[TMB]{MakeADFun}}}
\item{opt}{The output from \code{\link[stats]{nlminb}}}
\item{sdrep}{The output from \code{\link[TMB]{sdreport}}}
\item{interal}{Objects useful for package function, i.e., all arguments
               passed during the call}
\item{run_time}{Total time to run model}
}
}
\description{
Fits a dynamic structural equation model
}
\details{
A DSEM involves (at a minimum):
\describe{
  \item{Time series}{a matrix \eqn{\mathbf X} where column \eqn{\mathbf x_c} for variable c is
        a time-series;}
  \item{Path diagram}{a user-supplied specification for the path coefficients, which
        define the precision (inverse covariance) \eqn{\mathbf Q} for a matrix of state-variables
        and see \code{\link{make_dsem_ram}} for more details on the math involved.}
}
The model also estimates the time-series mean \eqn{ \mathbf{\mu}_c } for each variable.
The mean and precision matrix therefore define a Gaussian Markov random field for \eqn{\mathbf X}:

\deqn{ \mathrm{vec}(\mathbf X) \sim \mathrm{MVN}( \mathrm{vec}(\mathbf{I_T} \otimes \mathbf{\mu}), \mathbf{Q}^{-1}) }

Users can the specify
a distribution for measurement errors (or assume that variables are measured without error) using
argument \code{family}.  This defines the link-function \eqn{g_c(.)} and distribution \eqn{f_c(.)}
for each time-series \eqn{c}:

\deqn{ y_{t,c} \sim f_c( g_c^{-1}( x_{t,c} ), \theta_c )}

\code{dsem} then estimates all specified coefficients, time-series means \eqn{\mu_c}, and distribution
measurement errors \eqn{\theta_c} via maximizing a log-marginal likelihood, while
also estimating state-variables \eqn{x_{t,c}}.
\code{summary.dsem} then assembles estimates and standard errors in an easy-to-read format.
Standard errors for fixed effects (path coefficients, exogenoux variance parameters, and measurement error parameters)
are estimated from the matrix of second derivatives of the log-marginal likelihod,
and standard errors for random effects (i.e., missing or state-space variables) are estimated
from a generalization of this method (see \code{\link[TMB]{sdreport}} for details).

Any column \eqn{\mathbf x_c} of \code{tsdata} that includes only \code{NA} values
represents a latent variable, and all others are called manifest variables.
The identifiability criteria for latent variables
can be complicated.  To explain, we ignore lagged effects (only simultaneous paths)
and classify three types of latent variables:
\describe{
  \item{factor latent variables: }{any latent variable \eqn{\mathbf F} that includes paths out from it
        to manifest variables, but has no paths from manifest variables into \eqn{\mathbf F} is a
        factor variable.  These are identifable by fixing their SD (i.e., at one), and using a
        trimmed Cholesky parameterization (i.e., each successive factor includes fewer paths to
        manifest variables).  See the DFA vignette for an example.  Factor latent variables
        can be used to represent residual covariance while also estimating the source of
        that covariance explicitly}
  \item{intermediate latent variables: }{Any latent variable \eqn{\mathbf Y} that includes paths in
        from some manifest variables \eqn{\mathbf X} and some paths out to manifest variables
        \eqn{\mathbf Z} is an intermediate latent variable.  In general, the at least one path
        in or out must be fixed a priori (e.g., at one) to identify the scale of the intermediate
        LV.  These intermediate latent variables can represent ecological concepts that serve
        as intermediate link between different manifest variables}
  \item{composite latent variables: }{Any latent variable \eqn{\mathbf C} that includes paths in
        from some manifest variables \eqn{\mathbf X} and no paths out to manifest variables
        is a composite latent variable.  In general, you must fix all paths to composite variables
        a priori, and must also fix the SD a priori (e.g., at zero).  These composite variables
        allow DSEM to estimate a response with standard errors that integrates
        across multiple manifest variables}
}
As stated, these criteria do not involve paths from one to another latent variable.  These
are also possible, but involve more complicated identifiability criteria.
}
\examples{
# Define model
sem = "
  # Link, lag, param_name
  cprofits -> consumption, 0, a1
  cprofits -> consumption, 1, a2
  pwage -> consumption, 0, a3
  gwage -> consumption, 0, a3
  cprofits -> invest, 0, b1
  cprofits -> invest, 1, b2
  capital -> invest, 0, b3
  gnp -> pwage, 0, c2
  gnp -> pwage, 1, c3
  time -> pwage, 0, c1
"

# Load data
data(KleinI, package="AER")
TS = ts(data.frame(KleinI, "time"=time(KleinI) - 1931))
tsdata = TS[,c("time","gnp","pwage","cprofits",'consumption',
               "gwage","invest","capital")]

# Fit model
fit = dsem( sem=sem,
            tsdata = tsdata,
            estimate_delta0 = TRUE,
            control = dsem_control(quiet=TRUE) )
summary( fit )
plot( fit )
plot( fit, edge_label="value" )

}
\references{
**Introducing the package, its features, and comparison with other software
(to cite when using dsem):**

Thorson, J. T., Andrews, A., Essington, T., Large, S. (2024).
Dynamic structural equation models synthesize
ecosystem dynamics constrained by ecological mechanisms.
Methods in Ecology and Evolution. \doi{10.1111/2041-210X.14289}
}
