% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fun.R
\name{sample_char}
\alias{sample_char}
\title{Draw a sample of n random characters 
(from given characters).}
\usage{
sample_char(x_char = c(letters, LETTERS), n = 1, replace = FALSE, ...)
}
\arguments{
\item{x_char}{Population of characters to sample from. 
Default: \code{x_char = c(letters, LETTERS)}.}

\item{n}{Number of characters to draw. 
Default: \code{n = 1}.}

\item{replace}{Boolean: Sample with replacement? 
Default: \code{replace = FALSE}.}

\item{...}{Other arguments.
(Use for specifying \code{prob}, as passed to \code{sample()}.)}
}
\value{
A text string (scalar character vector).
}
\description{
\code{sample_char} draws a sample of  
\code{n} random characters from a given range of characters.
}
\details{
By default, \code{sample_char} draws \code{n = 1} 
a random alphabetic character from  
\code{x_char = c(letters, LETTERS)}.

As with \code{sample()}, the sample size \code{n} must not exceed 
the number of available characters \code{nchar(x_char)}, 
unless \code{replace = TRUE} (i.e., sampling with replacement).
}
\examples{
sample_char()  # default
sample_char(n = 10)
sample_char(x_char = "abc", n = 10, replace = TRUE)
sample_char(x_char = c("x y", "6 9"), n =  6, replace = FALSE)
sample_char(x_char = c("x y", "6 9"), n = 20, replace = TRUE)

# Biased sampling: 
sample_char(x_char = "abc", n = 20, replace = TRUE, 
             prob = c(3/6, 2/6, 1/6))

# Note: By default, n must not exceed nchar(x_char):
sample_char(n = 52, replace = FALSE)    # works, but
# sample_char(n = 53, replace = FALSE)  # would yield ERROR; 
sample_char(n = 53, replace = TRUE)     # works again.

}
\seealso{
Other sampling functions: 
\code{\link{coin}()},
\code{\link{dice_2}()},
\code{\link{dice}()},
\code{\link{sample_date}()},
\code{\link{sample_time}()}
}
\concept{sampling functions}
