% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel_conc.R
\name{ds_rel_conc}
\alias{ds_rel_conc}
\alias{rel_conc}
\title{Compute Relative Concentration}
\usage{
ds_rel_conc(.data, .cols, .name)

rel_conc(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble} with sf geometry}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with relative concentration. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_rel_conc from rel_conc}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Relative Concentration
}
\examples{
data('de_county')
ds_rel_conc(de_county, c(pop_black, starts_with('pop_')))
ds_rel_conc(de_county, c(pop_black, starts_with('pop_')), 'rel_conc')
}
\concept{concentration}
