% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPolarized.r
\name{plotPolarized}
\alias{plotPolarized}
\title{Plot Polarized Genotypes}
\usage{
plotPolarized(
  genotypes,
  HI,
  cols = c("#FFFFFF", "#800080", "#FFE500", "#008080"),
  ...
)
}
\arguments{
\item{genotypes}{A character matrix comprising of _012 encodings.}

\item{HI}{A numeric vector of individual hybrid indices with length equal to number
of rows in \code{genotypes}.}

\item{cols}{A vector of four colors, representing missing data, homozygotes for
genotype 0, heterozygotes and homozygotes for genotype 2.}

\item{...}{Additional selected arguments passed to \link[graphics]{image} and
\link[graphics]{axis}.}
}
\value{
No return value, called for side effects. In the default plot, purple and green
represent sides of the barrier to gene flow encoded as \code{0} and \code{2}, respectively,
yellow shows heterozygotes and white represents missing or undetermined genotypes.
Individuals are ordered according to the sorted \code{HI}.
}
\description{
Plots genotypes that can be optionally polarized.
}
\details{
To import and polarize genotypes, use the \link{importPolarized} function.

When using \link{diem}, hybrid indices,
\code{HI}, can be found in the file 'HIwithOptimalPolarities.txt'. Alternatively,
calculate \code{HI} from the polarized genotypes as shown in the examples.

By default, the function plots colored tick marks for individuals, changing the
color at the steepest change in sorted \code{HI}. The second and fourth colors in
\code{cols} are used for the tick marks.
\itemize{
\item To turn off this feature, use the argument \code{tick = FALSE}.
\item To use custom tick mark colors, provide a vector of colors for all individuals
(equal to the number of rows in \code{genotypes}). The \strong{vector of colors must be
ordered} according to \code{order(HI)}.
\item To include individual \code{labels} (e.g., accession numbers), provide a character
vector with the \strong{names in the same order as they are} in the \code{genotypes}.
}
}
\examples{
gen <- importPolarized(
  file = system.file("extdata", "data7x10.txt", package = "diemr"),
  changePolarity = c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE),
  ChosenInds = 1:7
)

h <- apply(gen, 1, FUN = function(x) pHetErrOnStateCount(sStateCount(x)))[1, ]

plotPolarized(genotypes = gen, HI = h)

# Incorrect tick color order
plotPolarized(gen, h, col.ticks = c(rep("purple", 5), "green", "purple"), lwd = 3)

# Correct tick color order
plotPolarized(gen, h, col.ticks = c(rep("purple", 5), "green", "purple")[order(h)], lwd = 3)

# Correct individual label order 
plotPolarized(gen, h, labels = c(paste("purple", 1:5), "green 1", "purple 6"), ylab = "")
}
\seealso{
\link{plotMarkerAxis} to add chromosome information to the x axis.
}
