% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\docType{class}
\name{Tree-class}
\alias{Tree-class}
\title{Tree Class Definition}
\value{
An object of class \code{Tree}.
}
\description{
An S4 class to represent a tree structure.
}
\details{
A structured representation of a tree, which includes several slots to store
attributes, leaves, nodes, path, and additional information related to the
tree structure. The class \code{Tree} is primarily used in the creation,
manipulation, and display of tree structures.
}
\section{Slots}{

\describe{
\item{\code{NumberOfAttributes}}{\code{numeric} - Number of attributes in the tree.}

\item{\code{NumberOfLeaves}}{\code{numeric} - Number of leaves in the tree.}

\item{\code{Depth}}{\code{numeric} - Maximum depth of the tree.}

\item{\code{Attributes}}{\code{character} - Names of attributes in the tree.}

\item{\code{Leaves}}{\code{character} - Names of leaves in the tree.}

\item{\code{Aggregated}}{\code{character} - Names of aggregated nodes in the tree.}

\item{\code{IsMultiple}}{\code{logical} - Flag indicating if multiple leaves are
present in the tree.}

\item{\code{Multiple}}{\code{data.frame} - List of multiple leaves and their count.}

\item{\code{IsLeafAggregated}}{\code{logical} - Flag indicating if leaf-aggregated
nodes are present in the tree.}

\item{\code{LeafAggregated}}{\code{character} - Names of leaf-aggregated nodes in the
tree.}

\item{\code{Paths}}{\code{list} - Paths from the root to the leaves.}

\item{\code{Nodes}}{\code{list} - Nodes present in the tree.}

\item{\code{EvaluationOrder}}{\code{numeric} - Evaluation order for LeafAggregated
nodes.}

\item{\code{RootName}}{\code{character} - Name of the root node.}
}}

\seealso{
\itemize{
\item \code{\link{print.Tree}}: For printing a Tree object.
\item \code{\link{show.Tree}}: For showing a Tree object.
\item \code{\link{describe.Tree}}: For describing a Tree object.
}
}
