% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hap_unite.R
\name{hap_unite}
\alias{hap_unite}
\title{Unite Haplotype Summaries with Species Delimitation Outputs}
\usage{
hap_unite(hap_tbl, delim)
}
\arguments{
\item{hap_tbl}{output from \link{haplotype_tbl} or \link{collapse_others}.}

\item{delim}{output from \link{delim_join} or \link{delim_consensus}.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\description{
\code{hap_unite()} returns a single \link[tibble:tbl_df-class]{tbl_df} combining all
results from \link{haplotype_tbl} or \link{collapse_others} with results from \link{delim_join}
or \link{delim_consensus}.
}
\details{
Many functions in this package relies on the usage of unique haplotypes due to
known issues when using identical or duplicated sequences for species delimitation analysis.
Thus, these outputs will very often refer only to unique haplotypes within a given dataset,
which can be determined by using functions like \link{hap_collapse}. Assuming that a
duplicated or identical sequence should share the same properties as the first
sequence of the group has, \code{hap_unite()} combines the output of \link{haplotype_tbl}
with the output of \link{delim_join}. Alternativelly, one may use \link{collapse_others} and
\link{delim_consensus} as well. This output may be used for downstream analysis or
to determine in which cluster a given sequence belongs.
}
\examples{

# get haplotype table
hap_tbl <- haplotype_tbl(geophagus)

# unite
hap_unite(hap_tbl, geophagus_delims)

}
\author{
Pedro S. Bittencourt
}
