% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_date_df.R
\name{fix_date_df}
\alias{fix_date_df}
\title{Clean up messy date columns}
\usage{
fix_date_df(
  df,
  col.names,
  day.impute = 1,
  month.impute = 7,
  id = NULL,
  format = "dmy",
  excel = FALSE,
  roman.numeral = FALSE
)
}
\arguments{
\item{df}{A \code{dataframe} or \code{tibble} object with messy date
column(s)}

\item{col.names}{Character vector of names of columns of messy date data}

\item{day.impute}{Integer. Day of the month to be imputed if not available.
defaults to 1. Maximum value of 31. If day.impute is greater than the
number of days for a given month, then the last day of that month will be
imputed. If \code{day.impute = NA}, then \code{NA} will be imputed for
the date instead and a warning will be raised. If \code{day.impute = NULL}
then instead of imputing the day of the month, the function will fail.}

\item{month.impute}{Integer. Month to be be imputed if not available.
Defaults to 7 (July). If \code{month.impute = NA} then \code{NA} will be
imputed for the date instead and a warning will be raised. If
\code{month.impute = NULL} then instead of imputing the month, the
function will fail.}

\item{id}{Name of column containing row IDs. By default, the first column is
assumed.}

\item{format}{Character. The format which a date is mostly likely to be given
in. Either \code{"dmy"} (default) or \code{"mdy"}. If year appears to have
been given first, then YMD is assumed for the subject (format argument is
not used for these observations)}

\item{excel}{Logical. If a date is given as only numbers (no separators), and
is more than four digits, should the date be assumed to be from Excel
which counts the number of days from 1900-01-01? In most programming
languages (including R), days are instead calculated from 1970-01-01
and this is the default for this function (\code{excel = FALSE})}

\item{roman.numeral}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical. If TRUE,
months detected to have been given as Roman numerals will be converted.
Months are given in Roman numerals in some database systems and biological
records. Defaults to FALSE as this may occasionally interfere with months
in other formats.}
}
\value{
A \code{dataframe} or \code{tibble} object. Dependent on the type of
\code{df}. Selected columns are of type \code{Date} with the following
format \code{yyyy-mm-dd}
}
\description{
Tidies a \code{dataframe} object which has date columns
entered via a free-text box (possibly by different users) and are therefore
in a non-standardized format. Supports numerous separators including /,-, or
space. Supports all-numeric, abbreviation, or long-hand month notation. Where
day of the month has not been supplied, the first day of the month is
imputed. Either DMY or YMD is assumed by default. However, the US system of
MDY is supported via the \code{format} argument.
}
\examples{
data(exampledates)
fixed.df <- fix_date_df(exampledates, c("some.dates", "some.more.dates"))
fixed.df
}
\seealso{
\code{\link{fix_date_char}} which is similar to \code{fix_date_df()}
except can only be applied to character vectors.
}
