% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{ListModels}
\alias{ListModels}
\title{Retrieve all available model information for a DataRobot project}
\usage{
ListModels(project, orderBy = NULL, filter = NULL)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{orderBy}{character. Optional. A vector of keys to order the list by. You can
order by \code{metric} or \code{samplePct}. If the sort attribute is preceded by a
hyphen, models will be sorted in descending order, otherwise in ascending order.
Multiple sort attributes can be included as a comma-delimited string or in a vector.}

\item{filter}{list. Optional. A named list of parameters to search a model
by, such as \code{name}, \code{samplePct}, or \code{isStarred}.}
}
\value{
An S3 object of class listOfModels, which may be characterized
  using R's generic summary function or converted to a dataframe with
  the as.data.frame method.
}
\description{
This function requests the model information for the DataRobot
project specified by the project argument, described under Arguments.
This parameter may be obtained in several ways, including: (1), from
the projectId element of the list returned by ListProjects; (2), as
the object returned by the GetProject function; or (3), as the list
returned by the SetupProject function. The function returns an S3
object of class 'listOfModels'.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  ListModels(projectId)
  ListModels(projectId, orderBy=c("samplePct", "-metric"))
  ListModels(projectId, filter=list("sample_pct__gt" = 64, "name" = "Ridge"))
  ListModels(projectId, filter=list("isStarred" = TRUE))
}
}
