% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatingTables.R
\name{DownloadRatingTable}
\alias{DownloadRatingTable}
\title{Download a rating table to a CSV.}
\usage{
DownloadRatingTable(project, ratingTableId, filename)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{ratingTableId}{character. The ID of the rating table.}

\item{filename}{character. Filename of file to save the rating table to.}
}
\value{
Nothing returned, but downloads the file to the stated filename.
}
\description{
Download a rating table to a CSV.
}
\examples{
\dontrun{
 projectId <- "5984b4d7100d2b31c1166529"
 ratingTableId <- "5984b4d7100d2b31c1166529"
 file <- file.path(tempdir(), "ratingTable.csv")
 DownloadRatingTable(projectId, ratingTableId, file)
}
}
