% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_add_computed_variables.R
\name{prep_add_computed_variables}
\alias{prep_add_computed_variables}
\title{Insert missing codes for \code{NA}s based on rules}
\usage{
prep_add_computed_variables(
  study_data,
  meta_data,
  label_col,
  rules,
  use_value_labels
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{rules}{\link{data.frame} with the columns:
\itemize{
\item \code{VAR_NAMES}: \link{VAR_NAMES} of the variable to compute
\item \code{COMPUTATION_RULE}: A rule in \code{REDcap} style (see, e.g.,
\href{https://help.redcap.ualberta.ca/help-and-faq/project-best-practices/data-quality/example-data-quality-rules}{\code{REDcap} help},
\href{https://docs.google.com/document/d/1l3nGBgqqPKi5PtMe75g7q0dny8QzGMd_/edit?tab=t.0}{\code{REDcap} how-to}), and
\href{https://www.iths.org/wp-content/uploads/REDCap-Branching-Logic-2017-202.pdf}{\code{REDcap} branching logic}
that defines, how to compute the new values
}}

\item{use_value_labels}{\link{logical} In rules for factors, use the value labels,
not the codes. Defaults to \code{TRUE}, if any
\code{VALUE_LABELS} are given in the metadata.}
}
\value{
a \code{list} with the entry:
\itemize{
\item \code{ModifiedStudyData}: Study data with the new variables
}
}
\description{
Insert missing codes for \code{NA}s based on rules
}
\examples{
\dontrun{
study_data <- prep_get_data_frame("ship")
prep_load_workbook_like_file("ship_meta_v2")
meta_data <- prep_get_data_frame("item_level")
rules <- tibble::tribble(
  ~VAR_NAMES,  ~RULE,
  "BMI", '[BODY_WEIGHT_0]/(([BODY_HEIGHT_0]/100)^2)',
  "R", '[WAIST_CIRC_0]/2/[pi]', # in m^3
  "VOL_EST", '[pi]*([WAIST_CIRC_0]/2/[pi])^2*[BODY_HEIGHT_0] / 1000', # in l
 )
 r <- prep_add_computed_variables(study_data, meta_data,
   label_col = "LABEL", rules, use_value_labels = FALSE)
}
}
