% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-methods.R
\name{efficacyFunction}
\alias{efficacyFunction}
\alias{efficacyFunction,ModelEff-method}
\alias{efficacyFunction-ModelEff}
\title{Getting the Efficacy Function for a Given Model Type}
\usage{
efficacyFunction(model, ...)

\S4method{efficacyFunction}{ModelEff}(model, ...)
}
\arguments{
\item{model}{(\code{ModelEff})\cr the model.}

\item{...}{model specific parameters.}
}
\value{
A \code{\link[=efficacy]{efficacy()}} function that computes expected efficacy.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A function that returns an \code{\link[=efficacy]{efficacy()}} function that computes expected
efficacy for a given dose level, based on the model specific parameters.
}
\section{Functions}{
\itemize{
\item \code{efficacyFunction(ModelEff)}: 

}}
\examples{
my_data <- DataDual(
  doseGrid = c(0.001, seq(25, 300, 25)),
  placebo = TRUE
)

my_model <- Effloglog(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = my_data,
  const = 2
)

eff_fun <- efficacyFunction(my_model, theta1 = -4.8, theta2 = 3.7)
eff_fun(30)
}
\seealso{
\code{\link[=efficacy]{efficacy()}}.
}
