% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticLogNormalMixture-class}
\alias{LogisticLogNormalMixture-class}
\alias{.LogisticLogNormalMixture}
\alias{LogisticLogNormalMixture}
\alias{.DefaultLogisticLogNormalMixture}
\title{\code{LogisticLogNormalMixture}}
\usage{
LogisticLogNormalMixture(mean, cov, ref_dose, share_weight)

.DefaultLogisticLogNormalMixture()
}
\arguments{
\item{mean}{(\code{numeric})\cr the prior mean vector.}

\item{cov}{(\code{matrix})\cr the prior covariance matrix. The precision matrix
\code{prec} is internally calculated as an inverse of \code{cov}.}

\item{ref_dose}{(\code{number})\cr the reference dose \eqn{x*} (strictly positive
number).}

\item{share_weight}{(\code{proportion})\cr the prior weight for the share component.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{LogisticLogNormalMixture}} is the class for standard logistic model with
online mixture of two bivariate log normal priors.
}
\details{
This model can be used when data is arising online from the informative
component of the prior, at the same time with the data of the trial of
main interest. Formally, this is achieved by assuming that the probability
of a DLT at dose \eqn{x} is given by
\deqn{p(x) = \pi * p1(x) + (1 - \pi) * p2(x)}
where \eqn{\pi} is the probability for the model \eqn{p(x)} being the same
as the model \eqn{p1(x)}, which is the informative component of the prior.
From this model data arises in parallel: at doses \code{xshare}, DLT information
\code{yshare} is observed, in total \code{nObsshare} data points (see \code{\link{DataMixture}}).
On the other hand, \eqn{1 - \pi}, is the probability of a separate model
\eqn{p2(x)}. Both components have the same log normal prior distribution,
which can be specified by the user, and which is inherited from the
\code{\link{LogisticLogNormal}} class.
}
\section{Slots}{

\describe{
\item{\code{share_weight}}{(\code{proportion})\cr the prior weight for the share component
\eqn{p_{1}(x)}.}
}}

\note{
Typically, end users will not use the \code{.DefaultLogNormalMixture()} function.
}
\examples{
# Decide on the dose grid and MCMC options.
dose_grid <- 1:80
my_options <- McmcOptions()

# Classic model.
my_model <- LogisticLogNormal(
  mean = c(-0.85, 1),
  cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
  ref_dose = 50
)

empty_data <- Data(doseGrid = dose_grid)
prior_samples <- mcmc(empty_data, my_model, my_options)
plot(prior_samples, my_model, empty_data)

# Set up the mixture model and data share object.
model_share <- LogisticLogNormalMixture(
  share_weight = 0.1,
  mean = c(-0.85, 1),
  cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
  ref_dose = 50
)

empty_data_share <- DataMixture(
  doseGrid = dose_grid,
  xshare = rep(c(10, 20, 40), each = 4),
  yshare = rep(0L, 12),
)

# Compare with the resulting prior model.
prior_samples_share <- mcmc(empty_data_share, model_share, my_options)
plot(prior_samples_share, model_share, empty_data_share)
}
\seealso{
\code{\link{ModelLogNormal}}, \code{\link{LogisticNormalMixture}},
\code{\link{LogisticNormalFixedMixture}}.
}
