# countdown css template

    .countdown {
      background: inherit;
      position: absolute;
      cursor: pointer;
      font-size: 3rem;
      line-height: 1;
      border-color: #ddd;
      border-width: 3px;
      border-style: solid;
      border-radius: 15px;
      box-shadow: 0px 4px 10px 0px rgba(50, 50, 50, 0.4);
      -webkit-box-shadow: 0px 4px 10px 0px rgba(50, 50, 50, 0.4);
      margin: 0.6em;
      padding: 10px 15px;
      text-align: center;
      z-index: 10;
      -webkit-user-select: none;
         -moz-user-select: none;
          -ms-user-select: none;
              user-select: none;
    }
    .countdown {
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .countdown .countdown-time {
      background: none;
      font-size: 100%;
      padding: 0;
    }
    .countdown-digits {
      color: inherit;
    }
    .countdown.running {
      border-color: #BF1111FF;
      background-color: firebrick3;
    }
    .countdown.running .countdown-digits {
      color: #FFCBCBFF;
    }
    .countdown.finished {
      border-color: #DE3000FF;
      background-color: #F04124;
    }
    .countdown.finished .countdown-digits {
      color: #4A0900FF;
    }
    .countdown.running.warning {
      border-color: #CEAC04FF;
      background-color: #E6C229;
    }
    .countdown.running.warning .countdown-digits {
      color: #3A2F02FF;
    }
    
    .countdown.running.blink-colon .countdown-digits.colon {
      opacity: 0.1;
    }
    
    /* ------ Controls ------ */
    .countdown:not(.running) .countdown-controls {
      display: none;
    }
    
    .countdown-controls {
      position: absolute;
      top: -0.5rem;
      right: -0.5rem;
      left: -0.5rem;
      display: flex;
      justify-content: space-between;
      margin: 0;
      padding: 0;
    }
    
    .countdown-controls > button {
      font-size: 1.5rem;
      width: 1rem;
      height: 1rem;
      display: inline-block;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      font-family: monospace;
      padding: 10px;
      margin: 0;
      background: inherit;
      border: 2px solid;
      border-radius: 100%;
      transition: 50ms transform ease-in-out, 150ms opacity ease-in;
      --countdown-transition-distance: 10px;
    }
    
    .countdown .countdown-controls > button:last-child {
      transform: translate(calc(-1 * var(--countdown-transition-distance)), var(--countdown-transition-distance));
      opacity: 0;
      color: #FFCBCBFF;
      background-color: firebrick3;
      border-color: #BF1111FF;
    }
    
    .countdown .countdown-controls > button:first-child {
      transform: translate(var(--countdown-transition-distance), var(--countdown-transition-distance));
      opacity: 0;
      color: #4A0900FF;
      background-color: #F04124;
      border-color: #DE3000FF;
    }
    
    .countdown.running:hover .countdown-controls > button,
    .countdown.running:focus-within .countdown-controls > button{
      transform: translate(0, 0);
      opacity: 1;
    }
    
    .countdown.running:hover .countdown-controls > button:hover,
    .countdown.running:focus-within .countdown-controls > button:hover{
      transform: translate(0, calc(var(--countdown-transition-distance) / -2));
      box-shadow: 0px 2px 5px 0px rgba(50, 50, 50, 0.4);
      -webkit-box-shadow: 0px 2px 5px 0px rgba(50, 50, 50, 0.4);
    }
    
    .countdown.running:hover .countdown-controls > button:active,
    .countdown.running:focus-within .countdown-controls > button:active{
      transform: translate(0, calc(var(--coutndown-transition-distance) / -5));
    }
    
    /* ----- Fullscreen ----- */
    .countdown.countdown-fullscreen {
      z-index: 0;
    }
    
    .countdown-fullscreen.running .countdown-controls {
      top: 1rem;
      left: 0;
      right: 0;
      justify-content: center;
    }
    
    .countdown-fullscreen.running .countdown-controls > button + button {
      margin-left: 1rem;
    }

