% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost_output.R
\name{get_ucos_summary}
\alias{get_ucos_summary}
\title{Get trait-specific summary table from a ColocBoost output.}
\source{
See detailed instructions in our tutorial portal:
\url{https://statfungen.github.io/colocboost/articles/Interpret_ColocBoost_Output.html}
}
\usage{
get_ucos_summary(
  cb_output,
  outcome_names = NULL,
  region_name = NULL,
  ambiguous_cos = FALSE,
  min_abs_corr_between_ucos = 0.5,
  median_abs_corr_between_ucos = 0.8
)
}
\arguments{
\item{cb_output}{Output object from \code{colocboost} analysis}

\item{outcome_names}{Optional vector of names of outcomes, which has the same order as Y in the original analysis.}

\item{region_name}{Optional character string. When provided, adds a column with this gene name to the output table for easier filtering in downstream analyses.}

\item{ambiguous_cos}{Logical indicating whether to include ambiguous colocalization events. The default is FALSE.}

\item{min_abs_corr_between_ucos}{Minimum absolute correlation for variants across two trait-specific (uncolocalized) effects to be considered colocalized. The default is 0.5.}

\item{median_abs_corr_between_ucos}{Median absolute correlation for variants across two trait-specific (uncolocalized) effects to be considered colocalized. The default is 0.8.}
}
\value{
A list containing:
\itemize{
\item \code{ucos_summary}: A summary table for trait-specific, uncolocalized associations with the following columns:
\itemize{
\item \code{outcomes}: Outcome being analyzed
\item \code{ucos_id}: Unique identifier for trait-specific confidence sets
\item \code{purity}: Minimum absolute correlation of variables within trait-specific confidence sets
\item \code{top_variable}: The variable with highest variant-level probability of association (VPA)
\item \code{top_variable_vpa}: Variant-level probability of association (VPA) for the top variable
\item \code{ucos_npc}: Normalized probability of causal association for the trait-specific confidence set
\item \code{n_variables}: Number of variables in trait-specific confidence set
\item \code{ucos_index}: Indices of variables in the trait-specific confidence set
\item \code{ucos_variables}: List of variables in the trait-specific confidence set
\item \code{ucos_variables_vpa}: Variant-level probability of association (VPA) for all variables in the confidence set
\item \code{region_name}: Region name if provided through the region_name parameter
}
\item \code{ambiguous_cos_summary}: A summary table for ambiguous colocalization events with the following columns:
\itemize{
\item \code{outcomes}: Outcome in the ambiguous colocalization event
\item \code{ucos_id}: Unique identifiers for the ambiguous event
\item \code{min_between_purity}: Minimum absolute correlation between variables across trait-specific sets in the ambiguous event
\item \code{median_between_purity}: Median absolute correlation between variables across trait-specific sets in the ambiguous event
\item \code{overlap_idx}: Indices of variables that overlap between ambiguous trait-specific sets
\item \code{overlap_variables}: Names of variables that overlap between ambiguous trait-specific sets
\item \code{n_recalibrated_variables}: Number of variables in the recalibrated colocalization set from an ambiguous event
\item \code{recalibrated_index}: Indices of variables in the recalibrated colocalization set from an ambiguous event
\item \code{recalibrated_variables}: Names of variables in the recalibrated colocalization set from an ambiguous event
\item \code{recalibrated_variables_vcp}: Variant colocalization probabilities for recalibrated variables from an ambiguous event
\item \code{region_name}: Region name if provided through the region_name parameter
}
}
}
\description{
\code{get_ucos_summary} produces a trait-specific summary table for uncolocalized (single-trait)
associations from ColocBoost results. This is particularly useful for examining trait-specific signals
or for summarizing results from single-trait FineBoost analyses.
}
\examples{
# colocboost example with single trait analysis
set.seed(1)
N <- 1000
P <- 100
# Generate X with LD structure
sigma <- 0.9^abs(outer(1:P, 1:P, "-"))
X <- MASS::mvrnorm(N, rep(0, P), sigma)
colnames(X) <- paste0("SNP", 1:P)
L <- 1  # Only one trait for single-trait analysis
true_beta <- matrix(0, P, L)
true_beta[10, 1] <- 0.5 # SNP10 affects the trait
true_beta[80, 1] <- 0.2 # SNP11 also affects the trait but with lower effect
Y <- X \%*\% true_beta + rnorm(N, 0, 1)
res <- colocboost(X = X, Y = Y, output_level = 2)
# Get the trait-specifc effect summary
get_ucos_summary(res)

}
\seealso{
Other colocboost_utilities: 
\code{\link{get_cormat}()},
\code{\link{get_cos}()},
\code{\link{get_cos_purity}()},
\code{\link{get_cos_summary}()},
\code{\link{get_hierarchical_clusters}()}
}
\concept{colocboost_utilities}
\keyword{colocboost_inference}
