% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractTree.R
\name{extractTree}
\alias{extractTree}
\title{Extract a tree from the complete Avian Phylogeny for a set of species}
\usage{
extractTree(
  species = "all_species",
  label_type = "scientific",
  taxonomy_year = 2023,
  version = "1.4",
  data_path = FALSE
)
}
\arguments{
\item{species}{A character vector either of scientific names (directly as they come out of the
eBird taxonomy, i.e. without underscores) or of six-letter eBird species codes. Any elements of
the species vector that do not match a species-level taxon in the specified eBird taxonomy
will result in an error. Default is set to "all_species".}

\item{label_type}{Either "scientific" or "code". Default is set to "scientific".}

\item{taxonomy_year}{The eBird taxonomy year the tree should be output in. Current options
include 2021, 2022, and 2023. Both numeric and character inputs are acceptable here. Any value
aside from these years will result in an error. Default is set 2023.}

\item{version}{The desired version of the tree. Default to the most recent
version of the tree. Other versions available are '1.2','1.3','1.4', and can be passed as
a character string or as numeric.}

\item{data_path}{Default to \code{FALSE}, it will look for a path containing the bird tree.
If the tree has not been downloaded yet using \code{\link[=get_avesdata_repo]{get_avesdata_repo()}}, it will load the default tree
using \code{\link[utils:data]{utils::data()}} as long as \code{version} and \code{taxonomy_year} are empty or match the default version.
If the tree has been downloaded using \code{\link[=get_avesdata_repo]{get_avesdata_repo()}}, it will read the tree file corresponding
to the \code{version} and \code{taxonomy_year} provided and load it as a \code{phylo} object.}
}
\value{
A phylogeny of the specified taxa in the specified eBird taxonomy version and clootl
tree version.
}
\description{
Extract a tree from the complete Avian Phylogeny for a set of species
}
\details{
This function first ensures that the requested output species overlap with species-level
taxa in the requested eBird taxonomy. If they do not, the function will error out. The onus is
on the user to ensure the requested taxa are valid. This is critical to ensure no unexpected
analysis hiccups later--you don't want to find out many steps later that your dataset doesn't
match your phylogeny. The eBird database is currently (as of Mar 2025) in 2024 taxonomy.
Trees available in 2024 taxonomy will be available by June 2025. The 2025 taxonomy will be released
to the public in October or November 2025. The intention is to release a tree in 2025 taxonomy
concurrently with the publication of the taxonomy itself.
}
\examples{
ex1 <- extractTree(species=c("amerob", "canwar", "reevir1", "yerwar", "gockin"),
   label_type="code")
ex2 <- extractTree(species=c("Turdus migratorius",
                             "Setophaga dominica",
                             "Setophaga ruticilla",
                             "Sitta canadensis"),
   label_type="scientific",
   taxonomy_year="2021",
   version="1.4")

}
\author{
Eliot Miller, Luna Sanchez Reyes, Emily Jane McTavish
}
