% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartographr.R
\name{plot_map}
\alias{plot_map}
\title{Plot a map with custom palette}
\usage{
plot_map(...)
}
\arguments{
\item{...}{Variable argument list:
\itemize{
\item \code{osm}: A list retrieved from osmdata containing map data.
\item \code{palette}: A character string specifying the name of the palette to use. The default is "imhof".
Additional arguments are passed on to the preprocessing and plotting functions.
}}
}
\value{
A \code{ggplot} object representing the map with the chosen palette.
}
\description{
This function takes an 'osmdata' (osm) object and a palette name, preprocesses the
map data if not already done, and plots the map using 'ggplot2' with the specified color palette.
}
\examples{
data("osm")
my_map <- osm |> plot_map(palette = 'gray')

}
