% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigonometric.R
\name{gen_helicalspiral}
\alias{gen_helicalspiral}
\title{Generate Helical Hyper Spiral}
\usage{
gen_helicalspiral(n = 500, p = 4, noise_fun = gen_noisedims, ...)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{noise_fun}{A function specifying which noise generation function to use for the additional dimensions. Default is \code{gen_noisedims}. Other options include \code{gen_wavydims1}, \code{gen_wavydims2}, and \code{gen_wavydims3}.}

\item{...}{Additional arguments passed to the selected \code{noise_fun} (e.g., \code{m}, \code{s}, \code{theta}, \code{x1_vec}, \code{data}).}
}
\value{
A data containing a helical hyper spiral.
}
\description{
This function generates a dataset representing a structure with a helical hyper spiral.
}
\examples{
set.seed(20240412)
helicalspiral <- gen_helicalspiral(n = 500, p = 4)
}
