% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_wavydims2}
\alias{gen_wavydims2}
\title{Generate Random Noise Dimensions With Wavy Pattern}
\usage{
gen_wavydims2(n = 500, p = 4, x1_vec)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{x1_vec}{A numeric vector representing the first dimension of the data structure.}
}
\value{
A data containing the generated random noise dimensions.
}
\description{
This function generates random noise dimensions by adding wavy patterns.
}
\examples{
set.seed(20240412)
theta <- seq(0, 2 * pi, length.out = 500)
x1 <- sin(pi) * cos(theta)
gen_wavydims2(n = 500, p = 4, x1_vec = x1)

}
