% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{include_card}
\alias{include_card}
\title{Display card in knitr/Quarto document (SVG via data URI)}
\usage{
include_card(
  svg_string,
  width = "100\%",
  alt = "Card generated by cardargus",
  dpi = 300,
  engine = c("auto", "chrome", "rsvg")
)
}
\arguments{
\item{svg_string}{SVG string from \code{svg_card()}.}

\item{width}{Display width (CSS units), e.g. \code{"100\%"}, \code{"500px"}.}

\item{alt}{Alternative text for accessibility.}

\item{dpi}{Fallback DPI used when output is not HTML (default 300).}

\item{engine}{Rendering engine for non-HTML output: \code{"auto"}, \code{"chrome"}, or \code{"rsvg"}.}
}
\value{
Knitr output for the current format.
}
\description{
Embeds the SVG as an \verb{<img>} using a \verb{data:image/svg+xml;base64,...} URI.
This is more robust than inline \verb{<svg>} for Pandoc/pkgdown (avoids "unclosed div"
warnings). For non-HTML outputs, it falls back to \code{include_card_png()}.
}
