% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_external.R
\name{create_prop}
\alias{create_prop}
\title{Create the inputs to evaluate the quality of proportion estimations}
\usage{
create_prop(
  var,
  denominator = NULL,
  domains = NULL,
  subpop = NULL,
  design,
  ci = FALSE,
  deff = FALSE,
  ess = FALSE,
  ajuste_ene = FALSE,
  rel_error = FALSE,
  log_cv = FALSE,
  unweighted = FALSE,
  standard_eval = FALSE,
  eclac_input = FALSE,
  ci_logit = FALSE,
  scheme = c("eclac_2020", "eclac_2023")
)
}
\arguments{
\item{var}{numeric variable within the \code{dataframe}, is the numerator of the ratio to be calculated.}

\item{denominator}{numeric variable within the \code{dataframe}, is the denominator of the ratio to be calculated. If the \code{var} parameter is dummy, it can be NULL.}

\item{domains}{domains to be estimated separated by the + character.}

\item{subpop}{integer dummy variable to filter the dataframe.}

\item{design}{complex design created by \code{survey} package.}

\item{ci}{\code{boolean} indicating if the confidence intervals must be calculated.}

\item{deff}{\code{boolean} design effect.}

\item{ess}{\code{boolean} effective sample size.}

\item{ajuste_ene}{\code{boolean} indicating if an adjustment for the sampling-frame transition period must be used.}

\item{rel_error}{\code{boolean} relative error.}

\item{log_cv}{\code{boolean} logarithmic coefficient of variation.}

\item{unweighted}{\code{boolean} add non-weighted count if required.}

\item{standard_eval}{\code{boolean} indicating if the function is wrapped inside another function, if \code{TRUE} avoid lazy eval errors.}

\item{eclac_input}{\code{boolean} return eclac inputs}

\item{ci_logit}{\code{boolean} indicating if interval confidence is logit, only available for proportions.}

\item{scheme}{\code{character} variable indicating the evaluation protocol to use for CEPAL standard. Options are "eclac_2020" and "eclac_2023". The "eclac_2020" option does not support ratio estimation.}
}
\value{
\code{dataframe} that contains the inputs and all domains to be evaluated.
}
\description{
\code{create_prop} generates a \code{dataframe} with the following elements: sum,
degrees of freedom, sample size, standard error, and coefficient of variation. The function allows
grouping in several domains.
}
\examples{
library(survey)
library(dplyr)

epf <- mutate(epf_personas, gasto_zona1 = if_else(zona == 1, gastot_hd, 0))
dc <- svydesign(ids = ~varunit, strata = ~varstrat, data = epf, weights = ~fe)
old_options <- options()
options(survey.lonely.psu = "certainty")

create_prop(var = "gasto_zona1", denominator = "gastot_hd", design = dc)

enusc <- filter(enusc, Kish == 1)

dc <- svydesign(ids = ~Conglomerado, strata = ~VarStrat, data = enusc, weights = ~Fact_Pers)
options(survey.lonely.psu = "certainty")
create_prop(var = "VP_DC", denominator = "hom_insg_taxi", design = dc)
options(old_options)
}
