% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-methods-ctmedmcphi.R
\name{print.ctmedmcphi}
\alias{print.ctmedmcphi}
\title{Print Method for Object of Class \code{ctmedmcphi}}
\usage{
\method{print}{ctmedmcphi}(x, digits = 4, ...)
}
\arguments{
\item{x}{an object of class \code{ctmedmcphi}.}

\item{digits}{Integer indicating the number of decimal places to display.}

\item{...}{further arguments.}
}
\value{
Prints a list of drift matrices.
}
\description{
Print Method for Object of Class \code{ctmedmcphi}
}
\examples{
set.seed(42)
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")
mc <- MCPhi(
  phi = phi,
  vcov_phi_vec = 0.1 * diag(9),
  R = 100L # use a large value for R in actual research
)
print(mc)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
