% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-methods-ctmedtraj.R
\name{plot.ctmedtraj}
\alias{plot.ctmedtraj}
\title{Plot Method for an Object of Class \code{ctmedtraj}}
\usage{
\method{plot}{ctmedtraj}(x, legend_pos = "topright", total = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{ctmedtraj}.}

\item{legend_pos}{Character vector.
Optional argument.
Legend position.}

\item{total}{Logical.
If \code{total = TRUE}, include the total effect trajectory.
If \code{total = FALSE}, exclude the total effect trajectory.}

\item{...}{Additional arguments.}
}
\value{
Displays trajectory plots of the effects.
}
\description{
Plot Method for an Object of Class \code{ctmedtraj}
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")

traj <- Trajectory(
  mu0 = c(3, 3, -3),
  time = 150,
  phi = phi,
  med = "m"
)

plot(traj)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
