% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_pegel_online.R
\name{pegel_online_station}
\alias{pegel_online_station}
\title{Get a Pegel-Online station}
\usage{
pegel_online_station(
  station,
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{station}{Station UUID, name, or number.}

\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with station metadata.
}
\description{
Get a Pegel-Online station
}
\details{
Fetches a single station record. Official docs:
https://pegel-online.api.bund.dev.
}
\examples{
\dontrun{
stations <- pegel_online_stations(params = list(limit = 1))
pegel_online_station(stations$uuid[[1]])
}

}
\seealso{
\code{\link[=pegel_online_stations]{pegel_online_stations()}} and \code{\link[=pegel_online_timeseries]{pegel_online_timeseries()}}.
}
