% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{cron_schedule}
\alias{cron_schedule}
\title{Cron Schedule}
\usage{
cron_schedule(
  quartz_cron_expression,
  timezone_id = "Etc/UTC",
  pause_status = c("UNPAUSED", "PAUSED")
)
}
\arguments{
\item{quartz_cron_expression}{Cron expression using Quartz syntax that
describes the schedule for a job.
See \href{https://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html}{Cron Trigger}
for details.}

\item{timezone_id}{Java timezone ID. The schedule for a job is resolved with
respect to this timezone.
See \href{https://docs.oracle.com/javase/7/docs/api/java/util/TimeZone.html}{Java TimeZone}
for details.}

\item{pause_status}{Indicate whether this schedule is paused or not. Either
\code{UNPAUSED} (default) or \code{PAUSED}.}
}
\description{
Cron Schedule
}
\seealso{
\code{\link[=db_jobs_create]{db_jobs_create()}}, \code{\link[=db_jobs_reset]{db_jobs_reset()}}, \code{\link[=db_jobs_update]{db_jobs_update()}}
}
