% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_residuals}
\alias{br_show_residuals}
\title{Show residuals vs fitted plot for regression models}
\usage{
br_show_residuals(breg, idx = NULL, plot_type = "fitted")
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{idx}{Index or names (focal variables) of the model(s). If \code{NULL} (default),
all models are included. If length-1, shows residuals for a single model.
If length > 1, shows faceted plots for multiple models.}

\item{plot_type}{Character string specifying the type of residual plot.
Options: "fitted" (residuals vs fitted values, default), "qq" (Q-Q plot),
"scale_location" (scale-location plot).}
}
\value{
A ggplot object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function creates residual plots to diagnose model fit. It can display:
\itemize{
\item Residuals vs fitted values plots for individual models
\item Multiple residual plots when multiple models are selected
\item Customizable plot appearance through ggplot2
}
}
\examples{
m <- br_pipeline(mtcars,
  y = "mpg",
  x = colnames(mtcars)[2:4],
  x2 = "vs",
  method = "gaussian"
)

# Single model residual plot
br_show_residuals(m, idx = 1)

# Multiple models
br_show_residuals(m, idx = c(1, 2))

# All models
br_show_residuals(m)

}
\seealso{
Other br_show: 
\code{\link{br_show_coxph_diagnostics}()},
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_circle}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_nomogram}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_survival_curves}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
