% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_nomogram}
\alias{br_show_nomogram}
\title{Show nomogram for regression models}
\usage{
br_show_nomogram(
  breg,
  idx = NULL,
  time_points = c(12, 24, 36),
  fun_at = NULL,
  point_range = c(0, 100),
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{breg}{A \code{breg} object with fitted regression models.}

\item{idx}{Index or name of the model to use for the nomogram.
If NULL, uses the first model.}

\item{time_points}{For Cox models, time points at which to show survival probabilities.
Default is c(12, 24, 36) representing months.}

\item{fun_at}{For non-survival models, the function values at which to show predictions.}

\item{point_range}{Range of points to use in the nomogram scale. Default is c(0, 100).}

\item{title}{Plot title. If NULL, generates automatic title.}

\item{subtitle}{Plot subtitle.}
}
\value{
A ggplot2 object showing the nomogram.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Creates a nomogram (graphical calculator) for regression models, particularly
useful for Cox proportional hazards models. A nomogram allows visual calculation
of predicted outcomes by assigning points to variable values and summing them
to get total points that correspond to predicted probabilities.
}
\examples{
\donttest{
# Cox regression nomogram

lung <- survival::lung |> dplyr::filter(ph.ecog != 3)
lung$ph.ecog <- factor(lung$ph.ecog)
mds <- br_pipeline(
  lung,
  y = c("time", "status"),
  x = c("age", "ph.ecog"),
  x2 = "sex",
  method = "coxph"
)
p <- br_show_nomogram(mds)
p


# Linear regression nomogram
mds_lm <- br_pipeline(
  mtcars,
  y = "mpg",
  x = c("hp", "wt"),
  x2 = "vs",
  method = "gaussian"
)
p2 <- br_show_nomogram(mds_lm, fun_at = c(15, 20, 25, 30))
p2
}
}
\seealso{
Other br_show: 
\code{\link{br_show_coxph_diagnostics}()},
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_circle}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_residuals}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_survival_curves}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
