% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_central_f_distribution.R
\name{non_central_f_distribution}
\alias{non_central_f_distribution}
\alias{non_central_f_pdf}
\alias{non_central_f_lpdf}
\alias{non_central_f_cdf}
\alias{non_central_f_lcdf}
\alias{non_central_f_quantile}
\title{Noncentral F Distribution Functions}
\usage{
non_central_f_distribution(df1, df2, lambda)

non_central_f_pdf(x, df1, df2, lambda)

non_central_f_lpdf(x, df1, df2, lambda)

non_central_f_cdf(x, df1, df2, lambda)

non_central_f_lcdf(x, df1, df2, lambda)

non_central_f_quantile(p, df1, df2, lambda)
}
\arguments{
\item{df1}{degrees of freedom for the numerator (df1 > 0)}

\item{df2}{degrees of freedom for the denominator (df2 > 0)}

\item{lambda}{noncentrality parameter (lambda >= 0)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Fisher F distribution.
}
\examples{
# Noncentral F distribution with df1 = 10, df2 = 10 and noncentrality
# parameter 1
dist <- non_central_f_distribution(10, 10, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
non_central_f_pdf(1, 5, 2, 1)
non_central_f_lpdf(1, 5, 2, 1)
non_central_f_cdf(1, 5, 2, 1)
non_central_f_lcdf(1, 5, 2, 1)
non_central_f_quantile(0.5, 5, 2, 1)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/f_dist.html}{Boost Documentation} for more details on the mathematical background.
}
