% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betapart_to_bioregion.R
\name{betapart_to_bioregion}
\alias{betapart_to_bioregion}
\title{Convert betapart dissimilarity to bioregion dissimilarity}
\usage{
betapart_to_bioregion(betapart_result)
}
\arguments{
\item{betapart_result}{An object produced by the betapart package (e.g.,
using the \code{beta.pair} function).}
}
\value{
A dissimilarity object of class \code{bioregion.pairwise.metric},
compatible with the bioregion package.
}
\description{
This function converts dissimilarity results produced by the betapart package
(and packages using betapart, such as phyloregion) into a dissimilarity
object compatible with the bioregion package. This function only converts
object types to make them compatible with bioregion; it does not modify the
beta-diversity values. This function allows the inclusion of phylogenetic
beta diversity to compute bioregions with bioregion.
}
\examples{
comat <- matrix(sample(0:1000, size = 50, replace = TRUE,
prob = 1 / 1:1001), 5, 10)
rownames(comat) <- paste0("Site", 1:5)
colnames(comat) <- paste0("Species", 1:10)

\dontrun{
beta_div <- betapart::beta.pair.abund(comat)
betapart_to_bioregion(beta_div)
}
}
\author{
Boris Leroy (\email{leroy.boris@gmail.com}) \cr
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) \cr
Pierre Denelle (\email{pierre.denelle@gmail.com})
}
