% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_1.R
\docType{methods}
\name{summary,BIOMOD.formated.data-method}
\alias{summary,BIOMOD.formated.data-method}
\title{\code{summary} method for \code{\link{BIOMOD.formated.data}} object class}
\usage{
\S4method{summary}{BIOMOD.formated.data}(object, calib.lines = NULL)
}
\arguments{
\item{object}{a \code{\link{BIOMOD.formated.data}} or \code{\link{BIOMOD.formated.data.PA}} 
object returned by the \code{\link{BIOMOD_FormatingData}} function}

\item{calib.lines}{(\emph{optional, default} \code{NULL}) \cr
an \code{array} object returned by \code{\link{get_calib_lines}} or 
\code{\link{bm_CrossValidation}} functions, to explore the distribution of calibration 
and validation datasets}
}
\value{
a \code{data.frame}
}
\description{
Summarize the number of presences, absences and 
pseudo-absences among the different potential dataset (calibration, 
validation and evaluation).
}
\examples{
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

## ----------------------------------------------------------------------- #
# Format Data with true absences
myBiomodData <- BIOMOD_FormatingData(resp.name = myRespName,
                                     resp.var = myResp,
                                     resp.xy = myRespXY,
                                     expl.var = myExpl)
myBiomodData
summary(myBiomodData)


}
\author{
Rémi Lemaire-Patin
}
