% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Response.R
\name{Response}
\alias{Response}
\title{Response Class}
\description{
A \code{Response} object represents represents the HTTP response that a
\code{Beakr} sends when it gets an HTTP request. It is by convention, the
object is always referred to as \code{res} (and the HTTP request is
\code{req}).
}
\section{Fields}{


\describe{
  \item{\code{headers}}{
  A list containing a key-value header list.
  }
  \item{\code{status}}{
  An integer HTTP status code.
  }
  \item{\code{body}}{
  Contains the response body.
  }
}
}

\section{Methods}{


\describe{
\item{\code{setHeader(key, value)}}{
  Sets a key-value header, i.e. \code{"Content-Type" = "text/html"}.
  }
  \item{\code{setContentType(type)}}{
  Sets the response content-type.
  }
  \item{\code{setStatus(status)}}{
  Sets the HTTP status code.
  }
  \item{\code{setBody(body)}}{
  Sets the body response.
  }
  \item{\code{redirect(url)}}{
  Sets the HTTP status to 302, "Found" and redirects to \code{url}.
  }
  \item{\code{json(txt, auto_unbox = TRUE)}}{
  Applies a function to text convert to JSON and sets the content-type to
  JSON.
  }
  \item{\code{text(txt)}}{
  Sets the response body text.
  }
  \item{\code{structured(protocol)}}{
  Sets the response protocol, i.e. "http"
  }
  \item{\code{plot(plot_object, base64 = TRUE, ...)}}{
  Sets the response type to plot image output.
  }
}
}

\seealso{
\code{\link{Response}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-setHeader}{\code{Response$setHeader()}}
\item \href{#method-setContentType}{\code{Response$setContentType()}}
\item \href{#method-setStatus}{\code{Response$setStatus()}}
\item \href{#method-setBody}{\code{Response$setBody()}}
\item \href{#method-redirect}{\code{Response$redirect()}}
\item \href{#method-json}{\code{Response$json()}}
\item \href{#method-text}{\code{Response$text()}}
\item \href{#method-structured}{\code{Response$structured()}}
\item \href{#method-plot}{\code{Response$plot()}}
\item \href{#method-clone}{\code{Response$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setHeader"></a>}}
\if{latex}{\out{\hypertarget{method-setHeader}{}}}
\subsection{Method \code{setHeader()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$setHeader(key, value)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setContentType"></a>}}
\if{latex}{\out{\hypertarget{method-setContentType}{}}}
\subsection{Method \code{setContentType()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$setContentType(type)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setStatus"></a>}}
\if{latex}{\out{\hypertarget{method-setStatus}{}}}
\subsection{Method \code{setStatus()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$setStatus(status)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setBody"></a>}}
\if{latex}{\out{\hypertarget{method-setBody}{}}}
\subsection{Method \code{setBody()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$setBody(body)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-redirect"></a>}}
\if{latex}{\out{\hypertarget{method-redirect}{}}}
\subsection{Method \code{redirect()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$redirect(url)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-json"></a>}}
\if{latex}{\out{\hypertarget{method-json}{}}}
\subsection{Method \code{json()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$json(txt, auto_unbox = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-text"></a>}}
\if{latex}{\out{\hypertarget{method-text}{}}}
\subsection{Method \code{text()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$text(txt)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-structured"></a>}}
\if{latex}{\out{\hypertarget{method-structured}{}}}
\subsection{Method \code{structured()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$structured(protocol)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$plot(plot_object, base64 = TRUE, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
