% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Middleware.R
\name{Middleware}
\alias{Middleware}
\title{Middleware class}
\description{
A \code{Middleware} object represents middleware functions that have access
to the request (\code{req}), response (\code{res}) and error (\code{err})
objects in request-response cycle via the \code{Router}.
}
\section{Methods}{


\describe{
  \item{\code{path}}{
  Returns the path for the specified middleware.
  }
  \item{\code{FUN}}{
  Returns the function response.
  }
  \item{\code{method}}{
  Returns the HTTP method for the middleware, i.e. "GET", "POST", etc.
  }
  \item{\code{protocol}}{
  Returns the protocol, "http" or "websocket".
  }
}



\describe{
  \item{\code{initialize(FUN, path, method, websocket)}}{
  Initializes the state of new middleware.
  }
}
}

\seealso{
\code{\link{Router}} and \code{\link{Middleware}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Middleware$new()}}
\item \href{#method-clone}{\code{Middleware$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Middleware$new(FUN, path, method, websocket)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Middleware$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
