% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{assign_tseg_internal}
\alias{assign_tseg_internal}
\title{Internal function that adds segment numbers to observations}
\usage{
assign_tseg_internal(dat, brkpts)
}
\arguments{
\item{dat}{A data frame that contains all data associated for a given animal
ID. Must include a column labeled \code{time1} that numbers each of the
observations in consecutive order, which is automatically generated by
\code{\link{filter_time}}.}

\item{brkpts}{A data frame of breakpoints for each animal ID (as generated by
\code{\link{get_breakpts}}).}
}
\value{
A data frame that updates the original data object by including the
  segment number associated with each observation in relation to the extracted
  breakpoints.
}
\description{
After breakpoints have been extracted for each animal ID, this function
assigns the associated segment number to observations for each animal ID.
These segments of observations will be used in the second stage of the model
framework to perform mixed-membership clustering by Latent Dirichlet
Allocation.
}
