% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_assurance.R
\name{assurance_nd_na}
\alias{assurance_nd_na}
\title{Bayesian Assurance Computation}
\usage{
assurance_nd_na(n, n_a, n_d, theta_0, theta_1, sigsq, alt, alpha = 0.05)
}
\arguments{
\item{n}{sample size (either scalar or vector)}

\item{n_a}{sample size at analysis stage that quantifies the amount
of prior information we have for parameter \eqn{\theta}. This should
be a single scalar value.}

\item{n_d}{sample size at design stage that quantifies the amount of
prior information we have for where the data is being generated from.
This should be a single scalar value.}

\item{theta_0}{parameter value that is known a priori
(typically provided by the client)}

\item{theta_1}{alternative parameter value that will be
tested in comparison to theta_0. See alt for specification options.}

\item{sigsq}{known variance \eqn{\sigma^2}.}

\item{alt}{specifies alternative test case, where \code{alt = "greater"}
tests if \eqn{\theta_1 > \theta_0}, \code{alt = "less"} tests if
\eqn{\theta_1 < \theta_0}, and \code{alt = "two.sided"}
performs a two-sided test. \code{alt = "greater"} by default.}

\item{alpha}{significance level}
}
\value{
objects corresponding to the assurance
\itemize{
\item{assurance_table:} table of sample sizes and
corresponding assurance values.
\item{assurance_plot:} assurance curve that is only
returned if n is a vector. This curve covers a wider range
of sample sizes than the inputted values specified
for n, where specific assurance values are marked in red.
}
}
\description{
Takes in a set of parameters and returns the exact Bayesian
assurance based on a closed-formed solution.
}
\examples{

## Assign the following fixed parameters to determine the Bayesian assurance
## for the given vector of sample sizes.
n <- seq(10, 250, 5)
n_a <- 1e-8
n_d <- 1e+8
theta_0 <- 0.15
theta_1 <- 0.25
sigsq <- 0.104
assur_vals <- assurance_nd_na(n = n, n_a = n_a, n_d = n_d, 
theta_0 = theta_0, theta_1 = theta_1,
sigsq = sigsq, alt = "two.sided", alpha = 0.05)
assur_vals$assurance_plot
}
