% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot,baycn-method}
\alias{plot,baycn-method}
\title{plot}
\usage{
\S4method{plot}{baycn}(
  x,
  presence = 0.4,
  direction = 0.2,
  edgeLabel = TRUE,
  mode = "directed",
  weighted = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class baycn.}

\item{presence}{A scalar between 0 and 1. This is the cutoff for considering
an edge to be present. For example, if presence = 0.4 then an edge is
considered to be present if the sum of the posterior proability for the two
edge directions is greater than 0.4. The edge will be considered to be absent
if this sum is less than 0.4.}

\item{direction}{A scalar between 0 and 1. This is the cutoff for determining
the direction of an edge. For example, if direction = 0.2 then an edge is
considered to be directed if the difference between the posterior proability
for the two edge directions is greater than 0.2. An edge will be considered
undirected if the difference is less than 0.2.}

\item{edgeLabel}{Logical - indicates whether the posterior probabilities
should be included as edge labels in the plot. If edgeLabel is TRUE then
weighted must also be set to TRUE.}

\item{mode}{See \code{\link[igraph]{graph_from_adjacency_matrix}} for
details.}

\item{weighted}{See \code{\link[igraph]{graph_from_adjacency_matrix}} for
details.}

\item{...}{Other Arguments passed to plot.igraph.}
}
\description{
plot
}
