% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{bblDatToMonolix}
\alias{bblDatToMonolix}
\alias{bblDatToNonmem}
\alias{bblDatToRxode}
\alias{bblDatToMrgsolve}
\alias{bblDatToPknca}
\title{Convert nlmixr2-compatible data to other formats (if possible)}
\usage{
bblDatToMonolix(
  model,
  data,
  table = nlmixr2est::tableControl(),
  rxControl = rxode2::rxControl(),
  env = NULL
)

bblDatToNonmem(
  model,
  data,
  table = nlmixr2est::tableControl(),
  rxControl = rxode2::rxControl(),
  env = NULL
)

bblDatToRxode(
  model,
  data,
  table = nlmixr2est::tableControl(),
  rxControl = rxode2::rxControl(),
  env = NULL
)

bblDatToMrgsolve(
  model,
  data,
  table = nlmixr2est::tableControl(),
  rxControl = rxode2::rxControl(),
  env = NULL
)

bblDatToPknca(
  model,
  data,
  table = nlmixr2est::tableControl(),
  rxControl = rxode2::rxControl(),
  env = NULL
)
}
\arguments{
\item{model}{rxode2 model for conversion}

\item{data}{Input dataset.}

\item{table}{is the table control; this is mostly to figure out if
there are additional columns to keep.}

\item{rxControl}{is the rxode2 control options; This is to figure
out how to handle the addl dosing information.}

\item{env}{When \code{NULL} (default) nothing is done.  When an
environment, the function \code{nlmixr2est::.foceiPreProcessData(data, env, model, rxControl)} is called on the provided environment.}
}
\value{
With the function \code{bblDatToMonolix()} return a list with:
\itemize{
\item Monolix compatible dataset ($monolix)
\item Monolix ADM information ($adm)
}

With the function \code{nlmixrDataToNonmem()} return a dataset that is
compatible with NONMEM.

With the function \code{nlmixrDataToMrgsolve()} return a dataset that is
compatible with \code{mrgsolve}.  Unlike NONMEM, it supports replacement
events with \code{evid=8} (note with \code{rxode2} replacement \code{evid} is \code{5}).

With the function \code{nlmixrDataToRxode()} this will normalize the
dataset to use newer \code{evid} definitions that are closer to NONMEM
instead of any classic definitions that are used at a lower level
}
\description{
Convert nlmixr2-compatible data to other formats (if possible)
}
\examples{

pk.turnover.emax3 <- function() {
  ini({
    tktr <- log(1)
    tka <- log(1)
    tcl <- log(0.1)
    tv <- log(10)
    ##
    eta.ktr ~ 1
    eta.ka ~ 1
    eta.cl ~ 2
    eta.v ~ 1
    prop.err <- 0.1
    pkadd.err <- 0.1
    ##
    temax <- logit(0.8)
    tec50 <- log(0.5)
    tkout <- log(0.05)
    te0 <- log(100)
    ##
    eta.emax ~ .5
    eta.ec50  ~ .5
    eta.kout ~ .5
    eta.e0 ~ .5
    ##
    pdadd.err <- 10
  })
  model({
    ktr <- exp(tktr + eta.ktr)
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    emax = expit(temax+eta.emax)
    ec50 =  exp(tec50 + eta.ec50)
    kout = exp(tkout + eta.kout)
    e0 = exp(te0 + eta.e0)
    ##
    DCP = center/v
    PD=1-emax*DCP/(ec50+DCP)
    ##
    effect(0) = e0
    kin = e0*kout
    ##
    d/dt(depot) = -ktr * depot
    d/dt(gut) =  ktr * depot -ka * gut
    d/dt(center) =  ka * gut - cl / v * center
    d/dt(effect) = kin*PD -kout*effect
    ##
    cp = center / v
    cp ~ prop(prop.err) + add(pkadd.err)
    effect ~ add(pdadd.err) | pca
  })
}

bblDatToMonolix(pk.turnover.emax3, nlmixr2data::warfarin)

bblDatToNonmem(pk.turnover.emax3, nlmixr2data::warfarin)

bblDatToMrgsolve(pk.turnover.emax3, nlmixr2data::warfarin)

bblDatToRxode(pk.turnover.emax3, nlmixr2data::warfarin)

}
\author{
Matthew L. Fidler
}
