% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_values}
\alias{am_values}
\title{Get all values from a map or list}
\usage{
am_values(doc, obj)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID, or \code{AM_ROOT} for the document root}
}
\value{
R list of values
}
\description{
Returns all values from an Automerge map or list as an R list.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "a", 1)
am_put(doc, AM_ROOT, "b", 2)
am_put(doc, AM_ROOT, "c", 3)

values <- am_values(doc, AM_ROOT)
values  # list(1, 2, 3)

am_close(doc)

}
