% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_sync_state_decode}
\alias{am_sync_state_decode}
\title{Deserialize a sync state}
\usage{
am_sync_state_decode(data)
}
\arguments{
\item{data}{A raw vector containing a serialized sync state}
}
\value{
An \code{am_syncstate} object.
}
\description{
Restores a sync state from a raw vector previously created by
\code{\link[=am_sync_state_encode]{am_sync_state_encode()}}. This allows continuing a sync session
from where it left off.
}
\examples{
sync_state <- am_sync_state()
bytes <- am_sync_state_encode(sync_state)

# Restore sync state
restored <- am_sync_state_decode(bytes)
restored

}
\seealso{
\code{\link[=am_sync_state_encode]{am_sync_state_encode()}}, \code{\link[=am_sync_state]{am_sync_state()}}
}
