% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_change_to_bytes}
\alias{am_change_to_bytes}
\title{Serialize a change to raw bytes}
\usage{
am_change_to_bytes(change)
}
\arguments{
\item{change}{An \code{am_change} object (from \code{\link[=am_get_changes]{am_get_changes()}},
\code{\link[=am_get_changes]{am_get_changes()}}, or \code{\link[=am_change_from_bytes]{am_change_from_bytes()}})}
}
\value{
A raw vector containing the serialized change
}
\description{
Converts an \code{am_change} object back to its serialized raw vector form.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "key", "value")
am_commit(doc, "Add key")

history <- am_get_changes(doc)
bytes <- am_change_to_bytes(history[[1]])
bytes

# Round-trip
restored <- am_change_from_bytes(bytes)
identical(am_change_to_bytes(restored), bytes)  # TRUE

am_close(doc)

}
