% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{replace_sp_chars_filename}
\alias{replace_sp_chars_filename}
\title{Replace Special Characters in File Name}
\usage{
replace_sp_chars_filename(dir_name, return_df = TRUE)
}
\arguments{
\item{dir_name}{A character string, referring to the directory of Rmd
files whose names should be replaced.}

\item{return_df}{A logical value, indicating if the old and new names should
be returned (in a tibble).}
}
\value{
A tibble containing the old and new names.
}
\description{
Replaces special characters in the name of an R or Rmd script.
}
\details{
If a filename contains one of the following special characters 
(ignore the quotes here): "\code{[ <>()|\\:&;#?*']}", the  
\link[knitr]{knit} function will replace 
them with underscores. Hence the filenames in the autoharp input directory 
and the output directory will not match, even allowing for the change in 
file extension. This will cause problems when we try to run 
\code{\link{render_one}} again on the same input directory.

This function renames the files in the input directory by replacing all 
special characters there.

The NUS LMS (LumiNUS) introduces parenthesized names or numbers in order 
to make filenames unique, so this function is necessary for NUS 
instructors.
}
