% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_compare.R
\name{assert_all_less_than}
\alias{assert_all_less_than}
\title{Assert input is less than a specified maximum value}
\usage{
assert_all_less_than(
  x,
  maximum,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object to check}

\item{maximum}{The maximum value to compare against (number)}

\item{msg}{A character string containing the error message to display if \code{x} is not less than the specified maximum value (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is less than the specified maximum value, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert all elements in a numeric vector/matrix are below some maximum value.
}
\examples{
try({
assert_all_less_than(1, 2) # Passes
assert_all_less_than(c(1,2,3), 4) # Passes
assert_all_less_than(c(1,2,3), 2) # Throws default error
assert_all_less_than(c(1,2,3), 2, msg = "custom error message") # Throws custom error
})

}
\concept{assert_comparison}
