% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{reduceSPC}
\alias{reduceSPC}
\title{Select a subset of columns from a SoilProfileCollection}
\usage{
reduceSPC(p, column_names = NULL)
}
\arguments{
\item{p}{a \code{SoilProfileCollection}}

\item{column_names}{a set of additional columns to include in the result}
}
\value{
a \code{SoilProfileCollection}
}
\description{
Reduce the number of columns in a \code{SoilProfileCollection} to a minimal set plus additional selected columns. Optional metadata columns are included if set. At a minimum the profile ID, horizon top and bottom depths, and horizon ID are included. Horizon designation and horizon texture class column names are included if metadata attributes are set. See details.
}
\details{
Minimum column names included (when \code{column_names = NULL})
\itemize{
\item \code{idname(p)}, \code{horizonDepths(p)}, \code{hzidname(p)}
}

Optional column names included (when metadata are set)
\itemize{
\item \code{hzdesgnname(p)}, \code{hztexclname(p)}, \code{GHL(p)}
}
}
\seealso{
\code{hzdesgnname()} \code{hztexclname()} \code{GHL()}
}
